#define ZONE1 A0
#define ZONE2 A1                   //PIN DEFNITIONS
#define ZONE3 A2
#define ZONE4 A3
#define zone1LED 9    //zone 1
#define zone2LED 8    //zone 2
#define zone3LED 7    //zone 3          /// pin numbers
#define zone4LED 6    // zone 4
#define pwrLED   5   // 
#define penalty  4

///////////////////////
float zone1_ini;
float zone2_ini;
float zone3_ini;                    /// holds initial values
float zone4_ini;
///// //////////////////
float val_read_zone1;
float val_read_zone2;
float val_read_zone3;               /// holds new checked values.
float val_read_zone4;
//////////////////////
float vo = 5;                            // comparator voltage, change this if using a different reference volt.
float R_known = 10000;                   // 10k comparator resistor
bool penal = 0;
int  beeper = 0;
byte counter=0;

float tolerance = 0.2;                   //  default 20% tolerance,  anything above or below this will trip the device. 
                                         // This value can be changed to widen or lessen the tolerance, must be in decimal percent 
                                         // 10% is 0.1, 50% is 0.5 etc.
   
void repeat();
void check_status();
bool check_status2(int y);
void beeps(int x);

void setup() {

  Serial.begin(9600);
  delay(200);
  pinMode(ZONE1, INPUT);
  pinMode(ZONE2, INPUT);
  pinMode(ZONE3, INPUT);
  pinMode(ZONE4, INPUT);
  pinMode(zone1LED, OUTPUT);
  pinMode(zone2LED, OUTPUT);
  pinMode(zone3LED, OUTPUT);
  pinMode(zone4LED, OUTPUT);
  pinMode(pwrLED, OUTPUT);
  pinMode(penalty, OUTPUT);
  digitalWrite(zone1LED, HIGH);
  delay(100);
  digitalWrite(zone2LED, HIGH);
  delay(50);
  digitalWrite(zone1LED, LOW);
  delay(100);
  digitalWrite(zone3LED, HIGH);
  delay(40);
  digitalWrite(zone2LED, LOW);
  delay(100);
  digitalWrite(zone4LED, HIGH);
  delay(50);
  digitalWrite(zone3LED, LOW);
  delay(100);
  digitalWrite(zone4LED, LOW);
  delay(75);
  digitalWrite(zone4LED, LOW);
  delay(200);
  digitalWrite(penalty, HIGH);
  delay(300);
  digitalWrite(penalty, LOW);
  delay(300);
  digitalWrite(penalty, HIGH);
  delay(300);
  digitalWrite(penalty, LOW);
  delay(300);
  digitalWrite(penalty, HIGH);
  delay(300);
  digitalWrite(penalty, LOW);
  delay(300);
  ini();
  digitalWrite(pwrLED, HIGH);
  digitalWrite(zone1LED, LOW);
  digitalWrite(zone2LED, LOW);
  digitalWrite(zone3LED, LOW);
  digitalWrite(zone4LED, LOW);
};

void ini() {
  zone1_ini = calculate_resis(analogRead(ZONE1));
  zone2_ini = calculate_resis(analogRead(ZONE2));
  zone3_ini = calculate_resis(analogRead(ZONE3));              // reads initial values and stores them
  zone4_ini = calculate_resis(analogRead(ZONE4));
};

float calculate_resis(float inp) {
  float volt, val1, val2, resis;
  if (inp >= 1023) {
    return 1014;                 
  }
  else {

    volt = ((inp / 1024) * 5);

    val1 = (volt / vo) * R_known;

    val2 = 1 - (volt / vo);     ///  maths for taking adc value and calculating the equivalent resistance.
    resis = val1 / val2;
    return resis;
  }
};

void loop() {
  digitalWrite(penalty, LOW);
  penal = 0;
  repeat();                       /// read the values, print the values
  check_status();                ///check for alarm on the values if failed light a resistor until it passes.
              ///print a new line

};
///repeat....


void repeat() {
  counter++; 

  val_read_zone1 = calculate_resis(analogRead(ZONE1));      /// read each zone to a variable val_read_zone
  
  val_read_zone2 = calculate_resis(analogRead(ZONE2));
   
  val_read_zone3 = calculate_resis(analogRead(ZONE3));
  
  val_read_zone4 = calculate_resis(analogRead(ZONE4));

  if(counter==255 || counter == 140) {
  Serial.print(val_read_zone1);
  Serial.print("  ");
  Serial.print(val_read_zone2);
  Serial.print("  ");
  Serial.print(val_read_zone3);                             // every 140th or 255th time this funciton is called, print this to the plotter; 
  Serial.print("  ");
  Serial.print(val_read_zone4);
  Serial.println(); 
  }
};

void check_status() {
 // compare current zone 1 to initial zone 1
  if(val_read_zone1 > 1000000){digitalWrite(zone1LED, LOW);}  // *so it doesnt read the internal resistance of the meter. spooky!*
  else if((val_read_zone1 > ((1.0 + tolerance) * zone1_ini)) || (val_read_zone1 < ((1.0 - tolerance) * zone1_ini))) {
    digitalWrite(zone1LED, HIGH);
    penal = 1;
    beeper = 1;
  }
  else {
    digitalWrite(zone1LED, LOW);
  }

  
 // compare current zone 2 to inital zone 2
  if(val_read_zone2 > 1000000){digitalWrite(zone2LED, LOW);}  
  else if ((val_read_zone2 > ((1.0 + tolerance)* zone2_ini)) || (val_read_zone2 < ((1.0 - tolerance) * zone2_ini))) {
    digitalWrite(zone2LED, HIGH);
    penal = 1;
    beeper = 2;
  }
  else {
    digitalWrite(zone2LED, LOW);
  }

  
  // compare....
  if(val_read_zone3 > 1000000){digitalWrite(zone3LED, LOW);}
  else if ((val_read_zone3 > ((1.0 + tolerance) * zone3_ini)) || (val_read_zone3 < ((1.0 - tolerance) * zone3_ini))) {       /// the function that checks the resistor values, a 20% more or less than the current resistance will trip the alarm.
    digitalWrite(zone3LED, HIGH);
    penal = 1;
    beeper = 3;
  }
  else {
    digitalWrite(zone3LED, LOW);
  }
  
  //compare....
  if(val_read_zone4 > 1000000){digitalWrite(zone4LED, LOW);}
  else if ((val_read_zone4 > ((1.0 + tolerance) * zone4_ini)) || (val_read_zone4 < ((1.0 - tolerance) * zone4_ini))) {
    digitalWrite(zone4LED, HIGH);
    penal = 1;
    beeper = 4;
  }
  else {
    digitalWrite(zone4LED, LOW);
  }

  // tally up if we got a hit. and start beepin!
  if (penal) {
    digitalWrite(penalty, HIGH); // turn on the penalty with a violation
   while (check_status2(beeper)) {   // keeps the penalty until non-violation is returned.
      delay(10);
   }
    delay(4000);                     // minimum 4 seconds penalty. 
    digitalWrite(penalty, LOW);      // turn off the penalty briefly
    delay(500);
    beeps(beeper);                   // get to beepin.
  }
  // or no hit and keep trucking!
  else {
    digitalWrite(penalty, LOW);
  }
}

void beeps(int x) {
  for (int i = 0; i < x; i++) {
    digitalWrite(penalty, HIGH);
    delay(120);
    digitalWrite(penalty, LOW);               //small function to beep the number of times, which zone went off. i.e. zone 4, 4 beeps. 
    delay(200);
  }
}

bool check_status2(int y) {
  repeat();                          // read the values 
  switch (y) {
    case 1:
      if ((val_read_zone1 > ((1.0 + tolerance) * zone1_ini)) || (val_read_zone1 < ((1.0 - tolerance) * zone1_ini))) {
        penal = 1;
      }
      else {                                                           // compare them again.
        penal = 0;
      }
      break;
    case 2:
      if ((val_read_zone2 > ((1.0 + tolerance) * zone2_ini)) || (val_read_zone2 < ((1.0 - tolerance) * zone2_ini))) {
        penal = 1;
      }
      else {
        penal = 0;
      }
      break;
    case 3:
      if ((val_read_zone3 > ((1.0 + tolerance) * zone3_ini)) || (val_read_zone3 < ((1.0 - tolerance) * zone3_ini))) {
        penal = 1;
      }
      else {
        penal = 0;
      }
      break;
    case 4:
      if ((val_read_zone4 > ((1.0 + tolerance) * zone4_ini)) || (val_read_zone4 < ((1.0 - tolerance) * zone4_ini))) {
        penal = 1;
      }
      else {
        penal = 0;
      }
      break;
    default:
      break;
  }

  if (penal) {
    return true;
  }
  else {
    return false;
  }

}
