/* This build is based loosely on a device discovered during the Odessa Uprising in 2014, Ukraine from photos. 
 * the device is thought to be a timer, possibly a command (radio) type device, but an alternate example with an 
 * Accelerometer is presented here as an anti disturbance.
 * 
 *  Some Notes: 
 *  The output is a calculated Roll, Pitch and Yaw from the Raw Data of the IMU. 
 *   
 *  The Arm Timer should be coded with enough time to allow the user to connect the battery, place the device,  
 *  and be hands off by the time the initial values are taken. The entire Arm Timer will also include the time 
 *  it takes to calculate the offest for the IMU(no more than 1 minute). I.E. ARM TIMER = 60 seconds, after 60
 *  seconds the device should already be placed, hands off. The device will then calculate the offsets ( about 1 minute). 
 *  After this has happened the ARMLIGHT will illuminate. 
 *  
 *  Calculations and IMU interpretations roughly based on Dejan's Arduino and MPU6050 Accelerometer and Gyroscope Sensor 
 *  @https://howtomechatronics.com/tutorials/arduino/arduino-and-mpu6050-accelerometer-and-gyroscope-tutorial , Check it out
 *  if you want more info on coding the IMU.
 *  
 *  Questions : support@eodkits.com
 *  
 */

#include <Wire.h>

////---Change these below to fine tune your device---/////

/// Timer in Seconds, enough to time to connect the battery and place the device, hands off, before
/// the initial readings are taken. Default : 60 (1 minute) 
double ARMTIMER = 60; //<---- CHANGE THIS TO CHANGE THE ARM TIMER.

// Changes to Roll, Pitch, or Yaw in degress to trigger device, Default: 15 degrees (between 0.01(yuck) and 90)  
float degreeTolerance = 15;//<---- CHANGE THIS TO CHANGE THE MOVMENT TOLERANCE. 

// Amount of Time in Seconds, device will Fire before Resetting. Default: 5 Seconds
double  FIRETIME = 5;  //<---- CHANGE THIS TO CHANGE HOW LONG THE DEVICE FIRES FOR




//// Thar B Headaches and Beasties Below //// 

// pin definitions.
#define SCR A0 
#define ARMLED 3
#define FIRELED 4



const int MPU = 0x68; // MPU6050 I2C address

//Global Variables
float AccX, AccY, AccZ;  // Raw Accel Data
float GyroX, GyroY, GyroZ; // Raw Gyro Data
float accAngleX, accAngleY, gyroAngleX, gyroAngleY, gyroAngleZ; // Angle holders
float roll, pitch, yaw; // the useable stuff, what humans use.
float AccErrorX, AccErrorY, GyroErrorX, GyroErrorY, GyroErrorZ; // quick and dirty offsets at startup.
float elapsedTime, currentTime, previousTime;  // timer keepers for the force over time equations.
long counter; // counter for drift reset.
bool fire=0; 
 
void setup() {
  Serial.begin(19200);
  //while(!Serial);
  pinMode(ARMLED, OUTPUT); 
  pinMode(FIRELED,OUTPUT); 
  pinMode(SCR, OUTPUT); 

  delay(1000); 
  
  Wire.begin();                      // Initialize comunication
  Wire.beginTransmission(MPU);       // Start communication with MPU6050 // MPU=0x68
  Wire.write(0x6B);                  // Talk to the register 6B
  Wire.write(0x00);                  // Make reset - place a 0 into the 6B register
  Wire.endTransmission(true);        //end the transmission

  Serial.println("not stuck");
}

void loop() {
 
  bool flash=false;  
  for(int i=0; i<ARMTIMER*2; i++){
  digitalWrite(ARMLED, flash); 
  delay(500); 
  flash = !flash;   
  }
  
  fire=0; 
  calculate_IMU_error();
 
  delay(200); 
  
  Serial.println("ARMED");
  digitalWrite(ARMLED, HIGH); 

  delay(200); 
  
  while(!fire){
  counter=millis(); 
  accAngleY=0; 
  accAngleX=0;
  gyroAngleX=0; 
  gyroAngleY=0;
  yaw=0; 
  // Reset every 15 seconds to get rid of the Drift. (Looking at you, YAW)
  
  while(counter + 15000 > millis() && !fire){ 
  // get the IMU Data
  getIMU();
  // get LDR reading  
  //compare to our starting readings

if(abs(yaw) >= degreeTolerance || abs(pitch) >= degreeTolerance || abs(roll) >= degreeTolerance){ 
     fire=1; 
     digitalWrite(FIRELED,HIGH);
      
  
  } 
  }
  }

  fireDevice(); 
}


void getIMU(){
  getAccelData(); 
  getGyroData(); 
  getRPY();
}

void getAccelData(){
  Wire.beginTransmission(MPU);
  Wire.write(0x3B); // Start with register 0x3B (ACCEL_XOUT_H)
  Wire.endTransmission(false);
  Wire.requestFrom(MPU, 6, true); // Read 6 registers total, each axis value is stored in 2 registers
  //For a range of +-2g, we need to divide the raw values by 16384, according to the datasheet
  AccX = (Wire.read() << 8 | Wire.read()) / 16384.0; // X-axis value
  AccY = (Wire.read() << 8 | Wire.read()) / 16384.0; // Y-axis value
  AccZ = (Wire.read() << 8 | Wire.read()) / 16384.0; // Z-axis value
  // Calculating Roll and Pitch from the accelerometer data
  accAngleX = (atan(AccY / sqrt(pow(AccX, 2) + pow(AccZ, 2))) * 180 / PI) - AccErrorX; 
  accAngleY = (atan(-1 * AccX / sqrt(pow(AccY, 2) + pow(AccZ, 2))) * 180 / PI) - AccErrorY;
}


void getGyroData(){
  previousTime = currentTime;        // Previous time is stored before the actual time read
  currentTime = millis();            // Current time actual time read
  elapsedTime = (currentTime - previousTime) / 1000; // Divide by 1000 to get seconds
  Wire.beginTransmission(MPU);
  Wire.write(0x43); // Gyro data first register address 0x43
  Wire.endTransmission(false);
  Wire.requestFrom(MPU, 6, true); // Read 4 registers total, each axis value is stored in 2 registers
  GyroX = (Wire.read() << 8 | Wire.read()) / 131.0; // For a 250deg/s range we have to divide first the raw value by 131.0, according to the datasheet
  GyroY = (Wire.read() << 8 | Wire.read()) / 131.0;
  GyroZ = (Wire.read() << 8 | Wire.read()) / 131.0;
  // Correct the outputs with the calculated error values
  GyroX = GyroX - GyroErrorX; 
  GyroY = GyroY - GyroErrorY;
  GyroZ = GyroZ - GyroErrorZ;
  // Currently the raw values are in degrees per seconds, deg/s, so we need to multiply by sendonds (s) to get the angle in degrees
  gyroAngleX = gyroAngleX + GyroX * elapsedTime; // deg/s * s = deg
  gyroAngleY = gyroAngleY + GyroY * elapsedTime;
}

void getRPY(){
  yaw =  yaw + GyroZ * elapsedTime;
  // Complementary filter - combine acceleromter and gyro angle values
  roll = 0.96 * gyroAngleX + 0.04 * accAngleX;
  pitch =0.96 * gyroAngleY + 0.04 * accAngleY;
    // Print the values on the serial monitor
  Serial.print("Roll : ");
  Serial.print(roll);
  Serial.print("  ||  Pitch: ");
  Serial.print(pitch);
  Serial.print("  ||  Yaw: ");
  Serial.println(yaw);
}


void fireDevice(){
  digitalWrite(ARMLED, LOW); 
  digitalWrite(SCR, HIGH);
  digitalWrite(FIRELED, HIGH); 
 // delay(5000);
 // Serial.println("firing");
 // fire = 0; 
 while(1){}; 
}

void calculate_IMU_error() {
  // We can call this funtion in the setup section to calculate the accelerometer and gyro data error. From here we will get the error values used in the above equations printed on the Serial Monitor.
  // Note that we should place the IMU flat in order to get the proper values, so that we then can the correct values
  // Read accelerometer values 200 times
  int c = 0;
  while (c < 200) {
    Wire.beginTransmission(MPU);
    Wire.write(0x3B);
    Wire.endTransmission(false);
    Wire.requestFrom(MPU, 6, true);
    AccX = (Wire.read() << 8 | Wire.read()) / 16384.0 ;
    AccY = (Wire.read() << 8 | Wire.read()) / 16384.0 ;
    AccZ = (Wire.read() << 8 | Wire.read()) / 16384.0 ;
    // Sum all readings
    AccErrorX = AccErrorX + ((atan((AccY) / sqrt(pow((AccX), 2) + pow((AccZ), 2))) * 180 / PI));
    AccErrorY = AccErrorY + ((atan(-1 * (AccX) / sqrt(pow((AccY), 2) + pow((AccZ), 2))) * 180 / PI));
    c++;
  }
  //Divide the sum by 200 to get the error value
  AccErrorX = AccErrorX / 200;
  AccErrorY = AccErrorY / 200;
  c = 0;
  // Read gyro values 200 times
  while (c < 200) {
    Wire.beginTransmission(MPU);
    Wire.write(0x43);
    Wire.endTransmission(false);
    Wire.requestFrom(MPU, 6, true);
    GyroX = Wire.read() << 8 | Wire.read();
    GyroY = Wire.read() << 8 | Wire.read();
    GyroZ = Wire.read() << 8 | Wire.read();
    // Sum all readings
    GyroErrorX = GyroErrorX + (GyroX / 131.0);
    GyroErrorY = GyroErrorY + (GyroY / 131.0);
    GyroErrorZ = GyroErrorZ + (GyroZ / 131.0);
    c++;
  }
  //Divide the sum by 200 to get the error value
  GyroErrorX = GyroErrorX / 200;
  GyroErrorY = GyroErrorY / 200;
  GyroErrorZ = GyroErrorZ / 200;
}
